Rem
Rem $Header: pyramid_georaster.sql 05-aug-2004.09:30:23 wexu Exp $
Rem
Rem pyramid_georaster.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      pyramid_georaster.sql
Rem
Rem    DESCRIPTION
Rem      generate pyramids
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    wexu        08/05/04 - RDT must be unique 
Rem    wexu        11/04/02 - minor fixes
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/30/02 - Created
Rem

-------------------------------------------------------------------
-- generate pyramids for a GeoRaster object
-- 
-- If rLevel is not specified , it generates pyramid until the size
-- of the smallest pyramid layer is right smaller than the blocking 
-- size if it is blocked, otherwise the size of the smallest level
-- is around 64X64. You can also choose different resampling.
-------------------------------------------------------------------
 
declare
  gr mdsys.sdo_georaster;
begin

  -- 1. the source 3-band truecolor georaster object
  select georaster into gr 
    from georaster_table where georid = 6 for update;

  -- 2. generate pyramids
  sdo_geor.generatePyramid(gr, 'resampling=NN');

  -- 3. update the original georaster object
  update georaster_table set georaster = gr where georid = 6;

  commit;
end;
/

-- quick check on the results

select pyramidLevel, count(*) from st_rdt_2 group by pyramidLevel;
select unique pyramidLevel, dbms_lob.getlength(rasterblock) 
  from st_rdt_2
  order by pyramidLevel;

select substr(sdo_geor.getPyramidType(georaster),1,10) pyramidType,
       sdo_geor.getPyramidMaxLevel(georaster) maxLevel
  from georaster_table where georid=6;

-- query a single cell value by specifying cell coordinate
-- in cell space and physical band number
select georid, 
       sdo_geor.getCellValue(georaster, 1, 100, 100, 0)
          "Cell value at pyramid level 1",
       sdo_geor.getCellValue(georaster, 2, 100, 100, 0)
          "Cell value at pyramid level 2"
  from georaster_table
  where georid = 6;


-------------------------------------------------------------------
-- delete pyramids of a GeoRaster object
-------------------------------------------------------------------
 
declare
  gr mdsys.sdo_georaster;
begin
  -- 1. the source 3-band truecolor georaster object
  select georaster into gr from georaster_table 
    where georid = 6 for update;

  -- 2. generate pyramids
  sdo_geor.deletePyramid(gr);

  -- 3. update the original georaster object
  update georaster_table set georaster = gr where georid = 6;

  commit;
end;
/

-- quick check on the results

select pyramidLevel, count(*) from st_rdt_2 group by pyramidLevel;
select unique pyramidLevel, dbms_lob.getlength(rasterblock) 
  from st_rdt_2
  order by pyramidLevel;

select substr(sdo_geor.getPyramidType(georaster),1,10) pyramidType,
       sdo_geor.getPyramidMaxLevel(georaster) maxLevel
  from georaster_table where georid=6;





